﻿<%@ Control Language="C#" AutoEventWireup="True" Inherits="VIRP_WEB.Controls.Custom.EFR.LabResultInterpretation" Codebehind="LabResultInterpretation.ascx.cs" %>

<%@ Register src="AddressEntry.ascx" tagname="Address" tagprefix="uc2" %>

<script type = "text/javascript">

    $(document).ready(function() {

        if ($('#<%= rbNeedBiomonitoringFollowUp.ClientID %> input:checked').val() == 0) {
            $('#<%= txtBioMonDueDate.ClientID %>').val('');
            $('#<%= txtReminderDate.ClientID %>').val('');

            $('#<%= txtBioMonDueDate.ClientID %>').attr('disabled', 'disabled');
            $('#<%= txtReminderDate.ClientID %>').attr('disabled', 'disabled');

        }
        else {
            $('#<%= txtBioMonDueDate.ClientID %>').removeAttr('disabled');
            $('#<%= txtReminderDate.ClientID %>').removeAttr('disabled');

        }

        $('#<%=rbNeedBiomonitoringFollowUp.ClientID %>').click(function() {

            if ($('#<%= rbNeedBiomonitoringFollowUp.ClientID %> input:checked').val() == 0) {
                $('#<%= txtBioMonDueDate.ClientID %>').val('');
                $('#<%= txtReminderDate.ClientID %>').val('');

                $('#<%= txtBioMonDueDate.ClientID %>').attr('disabled', 'disabled');
                $('#<%= txtReminderDate.ClientID %>').attr('disabled', 'disabled');

                ValidatorEnable($('[id*=RequiredValidatorDueDate]')[0], false);
                ValidatorEnable($('[id*=RequiredFieldValidatorReminderDate]')[0], false);

            }
            else {
                var currentTime = new Date();
                var bioMonDueDate = new Date(currentTime.getFullYear() + 5,
                                                currentTime.getMonth(), currentTime.getDate());
                var reminderDate = new Date(currentTime.getFullYear() + 5,
                                                currentTime.getMonth(), 1);
                reminderDate.setMonth(reminderDate.getMonth() - 1);

                $('#<%= txtBioMonDueDate.ClientID %>').val(bioMonDueDate.toString('M/d/yyyy'));
                $('#<%= txtReminderDate.ClientID %>').val(reminderDate.toString('M/d/yyyy'));

                ValidatorEnable($('[id*=RequiredValidatorDueDate]')[0], true);
                var validator = $('[id*=RequiredValidatorDueDate]')[0];
                validator.isvalid = true;
                ValidatorUpdateDisplay(validator);

                ValidatorEnable($('[id*=RequiredFieldValidatorReminderDate]')[0], true);
                validator = $('[id*=RequiredFieldValidatorReminderDate]')[0];
                validator.isvalid = true;
                ValidatorUpdateDisplay(validator);

                $('#<%= txtBioMonDueDate.ClientID %>').removeAttr('disabled');
                $('#<%= txtReminderDate.ClientID %>').removeAttr('disabled');

            }

        });

        $('#<%= btnSave.ClientID %>').click(function() {

            if ($('#<%= HiddenFieldCompletedInterpretation.ClientID%>').val() == '1') {

                return confirm('You are about to edit and save a previously completed Interpretation. Do you wish to proceed?');
            }

        });

        $('input[id *= txtBioMonDueDate]').blur(function() {

            var fwupDate = Date.parseExact($(this).val(), "M/d/yyyy");

            if (fwupDate != null) {

                if (Date.compare(fwupDate, Date.today()) > 0) {
                    if (Date.compare(fwupDate.add(-1).months().moveToFirstDayOfMonth(), Date.today()) >= 0) {
                        var remDate = fwupDate;
                    }
                    else {
                        var remDate = Date.today().add(1).days();
                    }

                    $('input[id *= txtReminderDate]').val(remDate.toString('M/d/yyyy'));
                    ValidatorEnable($('[id*=RequiredFieldValidatorReminderDate]')[0], false);
                }

            }
            else {
                $('input[id *= txtReminderDate]').val('');

            }
        });

        $('input[id *= txtReminderDate]').blur(function() {
            if ($(this).val() == '' 
                && $('#<%= rbNeedBiomonitoringFollowUp.ClientID %> input:checked').val() == 1) {
                ValidatorEnable($('[id*=RequiredFieldValidatorReminderDate]')[0], true);
            }
        });
    });
</script>
    
<uc2:Address ID="ProvAddress" runat="server" NameReadOnly="false" GroupingText = "&nbsp;Provider Address&nbsp;" ShowFacilityBoxAndPCPVAMCPanels = "true" ShowPrimaryAlternateAddressPanels = "false"   />
    
<br />    
    
<uc2:Address ID="PatientAddress" runat="server" NameReadOnly="true" GroupingText = "&nbsp;Patient Address&nbsp;" ShowFacilityBoxAndPCPVAMCPanels = "false" ShowPrimaryAlternateAddressPanels = "true" />
   
<br />

<asp:Panel ID="Panel2" runat="server" Width="99%" GroupingText="Interpretation Notes To Provider &nbsp;&nbsp;">
    <asp:TextBox ID="TextBoxInterpretationNotesToProvider" runat="server" Width="99%" TextMode="MultiLine" MaxLength="4000" Rows="4"></asp:TextBox>
</asp:Panel>

<br />

<asp:Panel ID="Panel1" runat="server" Width="99%" GroupingText="Interpretation Notes To Patient &nbsp;&nbsp;">
    <asp:TextBox ID="TextBoxInterpretationNotesToPatient" runat="server" Width="99%" TextMode="MultiLine" MaxLength="4000" Rows="4"></asp:TextBox>
</asp:Panel>     

<br />

<asp:Panel ID="PanelLetterFields1" runat="server" Width="99%" GroupingText="Letter Information &nbsp;&nbsp;">
    <br />
    <asp:Label SkinID="DataLabel" ID="LabelForTextBoxFrom" runat="server" AssociatedControlID="TextBoxFrom" Text="Provider Letter From:"></asp:Label>
    <br />
    <asp:TextBox ID="TextBoxFrom" runat="server" Width="99%" MaxLength="500"></asp:TextBox>
    <br />
    <br />
    <asp:Label SkinID="DataLabel" ID="LabelForTextBoxSubject" runat="server" AssociatedControlID="TextBoxSubject" Text="Provider Letter Subject (Patient name and last 4 digits of SSN will be appended to the end):"></asp:Label>
    <br />
    <asp:TextBox ID="TextBoxSubject" runat="server" Width="99%" MaxLength="500"></asp:TextBox>
    <br />
    <br />
    <asp:Label SkinID="DataLabel" ID="LabelForDropDownListSigningClinician" runat="server" AssociatedControlID="DropDownListSigningClinician" Text="Signing Clinician:"></asp:Label>
    <br />
    <asp:DropDownList ID="DropDownListSigningClinician" runat="server"
        AutoPostBack="False" 
        DataSourceID="ObjectDataSourceSigningClinician" 
        DataTextField="Value"
        DataValueField="Key"
        AppendDataBoundItems="true"
        Width="250">
    </asp:DropDownList>  
    <br />
    <br />
    <asp:Label SkinID="DataLabel" ID="LabelForTextBoxCCName" runat="server" AssociatedControlID="TextBoxCCName" Text="CC Name:"></asp:Label>
    <br />
    <asp:TextBox ID="TextBoxCCName" runat="server" Width="250" MaxLength="500"></asp:TextBox>
    <br />
    <br />
    <asp:Label SkinID="DataLabel" ID="LabelForTextBoxSigningCommentsProviderLetter" runat="server" AssociatedControlID="TextBoxSigningCommentsProviderLetter" 
        Text="Provider Letter Comment Before Signature:"></asp:Label>
    <br />
    <asp:TextBox ID="TextBoxSigningCommentsProviderLetter" runat="server" Width="99%" MaxLength="1000" TextMode="MultiLine" ></asp:TextBox>  
    <br />
    <br />
    <asp:Label SkinID="DataLabel" ID="LabelforTextBoxSigningCommentsPatientLetter" runat="server" AssociatedControlID="TextBoxSigningCommentsPatientLetter" 
        Text="Patient Letter Comment Before Signature:"></asp:Label>
    <br />
    <asp:TextBox ID="TextBoxSigningCommentsPatientLetter" runat="server" Width="99%" MaxLength="1000" TextMode="MultiLine" ></asp:TextBox>  

</asp:Panel> 
 
<br />

<asp:Panel ID = "PanelBioFollowUp" runat = "server" GroupingText = "Biomonitoring Follow Up &nbsp;&nbsp;" Width = "99%" > 
    <table cellpadding = "5" cellspacing = "5" border="0" > 
        <tr>
            <td>
            <asp:Panel ID = "rbPanelNeedBiomonitoringFollowUp" runat = "server" GroupingText = "Need Biomonitoring Follow Up?">
                
                <asp:RadioButtonList ID = "rbNeedBiomonitoringFollowUp" runat = "server" 
                    RepeatDirection = "Horizontal">
                    <asp:ListItem Value="1" Selected = "True">Yes</asp:ListItem>
                    <asp:ListItem Value ="0">No</asp:ListItem>   
                </asp:RadioButtonList>      
                <asp:RequiredFieldValidator ID = "NeedBiomonitoringFollowUpValidator" runat = "server" 
                    ValidationGroup = "InterpretSaveComplete" EnableClientScript = "true" SetFocusOnError = "true" Display = "Dynamic" 
                    ControlToValidate = "rbNeedBiomonitoringFollowUp" InitialValue = "" 
                    ErrorMessage = "Please answer Yes or No if Biomonitoring Followup needed.">
                </asp:RequiredFieldValidator> 
            </asp:Panel>
            </td>
            <td>
                &nbsp;
            </td>       
        </tr>
        <tr>        
            <td>
                <asp:Label SkinID="DataLabel" ID="LabelBioMonDueDate" runat="server" AssociatedControlID="txtBioMonDueDate" 
                    Text="Follow Up Biomonitoring Due Date (mm/dd/yyyy):">
                </asp:Label>
            </td>
            <td style="margin-left: 40px">
                <asp:TextBox ID="txtBioMonDueDate" runat="server">
                </asp:TextBox>
                <asp:CompareValidator ID = "BioFollowupDueDateValidator" runat = "server"                                    
                    ControlToValidate = "txtBioMonDueDate"
                    ValidationGroup = "InterpretSaveComplete"                                     
                    SetFocusOnError = "true" 
                    EnableClientScript = "true" 
                    Operator = "GreaterThan"                                        
                    ErrorMessage = "Follow Up Biomonitoring Due Date has to be in format(mm/dd/yyyy) and has to be a future date." 
                    Display = "Dynamic"
                    Type= "Date"/>  
                <asp:RequiredFieldValidator ID = "RequiredValidatorDueDate" runat = "server" 
                    ValidationGroup = "InterpretSaveComplete" EnableClientScript = "true" 
                    SetFocusOnError = "true" Display = "Dynamic"  Enabled="false"
                    ControlToValidate = "txtBioMonDueDate"  
                    ErrorMessage = "Follow Up Biomonitoring Due Date is required.">
                </asp:RequiredFieldValidator>                   
            </td>
        </tr>
        <tr>
            <td>
                <asp:Label SkinID="DataLabel" ID="LabelReminderDate" runat="server" AssociatedControlID="txtReminderDate" 
                    Text="Remind Me On (mm/dd/yyyy):">
                </asp:Label>
            </td>
            <td style="margin-left: 40px">
                <asp:TextBox ID="txtReminderDate" runat="server">
                </asp:TextBox>
                <asp:CompareValidator ID = "ReminderDateValidator" runat = "server"                                    
                    ControlToValidate = "txtReminderDate"
                    ControlToCompare = "txtBioMonDueDate"                                     
                    SetFocusOnError = "true" 
                    EnableClientScript = "true" 
                    Operator = "LessThanEqual" 
                    ValidationGroup = "InterpretSaveComplete"                                       
                    ErrorMessage = "Reminder Date has to be in format(mm/dd/yyyy) and no later than Biomonitoring Due Date." 
                    Display = "Dynamic"
                    Type= "Date" />
                        
                <asp:CompareValidator ID = "ReminderFutureDateValidator" runat = "server"                                    
                    ControlToValidate = "txtReminderDate"
                    ValidationGroup = "InterpretSaveComplete"                                     
                    SetFocusOnError = "true" 
                    EnableClientScript = "true" 
                    Operator = "GreaterThanEqual"                                         
                    ErrorMessage = "Follow Up Biomonitoring Reminder Date cannot be in the past." 
                    Display = "Dynamic"
                    Type= "Date"/>                   
                    <asp:RequiredFieldValidator ID = "RequiredFieldValidatorReminderDate" runat = "server" 
                    ValidationGroup = "InterpretSaveComplete" Enabled="false"
                    EnableClientScript = "true" SetFocusOnError = "true" Display = "Dynamic" 
                    ControlToValidate = "txtReminderDate"  
                    ErrorMessage = "Follow Up Biomonitoring Reminder Date is required.">
                    </asp:RequiredFieldValidator>                   
            </td>
                       
        </tr> 
        <tr>
            <td colspan = "2">
                <asp:Label SkinID="DataLabel" ID = "LabelBioFollowUp" runat = "server"/><asp:HyperLink ID = "LinkBioFollowUp" runat = "server"></asp:HyperLink> 
            </td>
        </tr>
    </table>
</asp:Panel>

<br />

<asp:Panel ID="Panel5" runat="server" Width="99%" GroupingText="">
    <table><tr><td>
        
    <asp:HiddenField ID="HiddenFieldCompletedInterpretation" runat = "server" value="0" />
    <asp:Button runat="server" ID="btnSave" 
        Text = "Save" ValidationGroup = "InterpretSaveComplete"
        onclick="BtnSave_Click" 
        />
    &nbsp;
    <asp:Button runat="server" ID="btnInterpretComplete" Text = "Interpret Complete"
            OnClientClick="if (!confirm('Please note that after pressing the Interpret Complete button this record will become static (non-editable). Are you sure that you want to complete this interpretation letter?')) return false;"
            onclick="BtnInterpretComplete_Click" ValidationGroup = "InterpretSaveComplete" />&nbsp;      
    <asp:Button runat="server" ID="btnAddPrintQueue" Text = "Add to Print Queue" 
            onclick="BtnAddPrintQueue_Click" OnClientClick = "alert('Letter has been added to print queue.')"  />&nbsp;
    <asp:Button runat="server" ID="btnPrintPrvdrLttr" Text = "Print Provider Letter" 
            onclick="BtnPrintPrvdrLttr_Click"  />&nbsp;
    <asp:Button runat="server" ID="btnPrintPatntLttr" Text = "Print Patient Letter" 
            onclick="BtnPrintPatntLttr_Click" />&nbsp;
    <asp:Button runat="server" ID="btnCancel" Text = "Back" 
            onclick="BtnCancel_Click" UseSubmitBehavior = "false" CssClass = "cancel" />
                  
    </td></tr></table>
</asp:Panel>
    
<asp:ObjectDataSource ID="ObjectDataSourceSigningClinician" runat="server" SelectMethod="GetOrderedClinicians" TypeName="VIRP.CRS.BLL.STD_SIGNING_CLINICIANManger">
    <SelectParameters>
        <asp:Parameter Name="CURRENT_USER" Type="String" />
        <asp:Parameter Name="CURRENT_REGISTRY_ID" Type="String" />
    </SelectParameters>
</asp:ObjectDataSource>